/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.crypto;

import java.security.SecureRandom;
import technicianlp.reauth.configuration.Profile;
import technicianlp.reauth.crypto.EncryptionAutomatic;
import technicianlp.reauth.crypto.EncryptionNone;
import technicianlp.reauth.crypto.PkceChallenge;
import technicianlp.reauth.crypto.ProfileEncryption;

public final class Crypto {
    private static String configPath = "";

    public static ProfileEncryption getProfileEncryption(Profile profile) {
        switch (profile.getValue("key")) {
            case "auto": {
                return new EncryptionAutomatic(configPath, profile.getValue("salt"));
            }
            case "none": {
                return new EncryptionNone();
            }
        }
        throw new IllegalArgumentException("Unknown Encryption Type");
    }

    public static ProfileEncryption newEncryption() {
        return new EncryptionAutomatic(configPath);
    }

    public static byte[] randomBytes(int length) {
        byte[] salt = new byte[length];
        new SecureRandom().nextBytes(salt);
        return salt;
    }

    public static PkceChallenge createPkceChallenge() {
        return new PkceChallenge();
    }

    public static void updateConfigPath(String configPath) {
        Crypto.configPath = configPath;
    }
}

